--> pralable
-- USE BD_Air_France;


IF OBJECT_ID('dbo.T_qualifs_qlf','U') IS NOT NULL
   DROP TABLE dbo.T_qualifs_qlf;
GO
IF OBJECT_ID('dbo.T_pilote_pil','U') IS NOT NULL
   DROP TABLE dbo.T_pilote_pil;
GO
IF OBJECT_ID('dbo.T_compagnie_cmp','U') IS NOT NULL
   DROP TABLE dbo.T_compagnie_cmp;
GO


CREATE TABLE T_compagnie_cmp
(cmp_comp VARCHAR(4), cmp_pays CHAR(3), cmp_nom VARCHAR(15),
 CONSTRAINT pk_compagnie PRIMARY KEY(cmp_comp));
GO

CREATE TABLE T_pilote_pil
(pil_brevet VARCHAR(6), pil_prenom VARCHAR(15), pil_nom VARCHAR(15), 
 pil_hvol DECIMAL(7,2), cmp_comp VARCHAR(4), 
 CONSTRAINT pk_pilote PRIMARY KEY(pil_brevet),
 CONSTRAINT fk_pil_cmp FOREIGN KEY(cmp_comp) REFERENCES T_compagnie_cmp(cmp_comp));
GO

CREATE TABLE T_qualifs_qlf
(pil_brevet VARCHAR(6), qlf_avi CHAR(4), qlf_valide DATE,
 CONSTRAINT fk_qlf_pil FOREIGN KEY(pil_brevet) REFERENCES T_pilote_pil(pil_brevet));
GO

INSERT INTO T_compagnie_cmp VALUES ('AF', 'fr', 'Air France');
INSERT INTO T_compagnie_cmp VALUES ('SING','sn', 'Singapore AL');
INSERT INTO T_compagnie_cmp VALUES ('CAST', 'fr', 'Castanet AL');

INSERT INTO T_pilote_pil VALUES ('PL-1', 'Pierre','Lamothe', 450, 'AF');
INSERT INTO T_pilote_pil VALUES ('PL-2', 'Didier','Linxe', 900, 'AF');
INSERT INTO T_pilote_pil VALUES ('PL-3', 'Michel','Castaings', 1000, 'SING');
INSERT INTO T_pilote_pil VALUES ('PL-4', 'Henri','Alqui', 3400, 'AF');

INSERT INTO T_qualifs_qlf VALUES ('PL-4', 'A320','20150624');
INSERT INTO T_qualifs_qlf VALUES ('PL-4', 'A340','20150624');
INSERT INTO T_qualifs_qlf VALUES ('PL-2', 'A320','20160404');
INSERT INTO T_qualifs_qlf VALUES ('PL-3', 'A330','20160513');

/* R7 */

SELECT  c.cmp_nom, p.pil_brevet, p.pil_prenom, p.pil_nom 
FROM            T_compagnie_cmp c
LEFT OUTER JOIN T_pilote_pil p 
ON              p.cmp_comp  = c.cmp_comp ;

SELECT  c.cmp_nom, p.pil_brevet, p.pil_prenom, p.pil_nom 
FROM             T_pilote_pil p
RIGHT OUTER JOIN T_compagnie_cmp c
ON               p.cmp_comp  = c.cmp_comp ;

/* R8 */


SELECT p.pil_brevet, q.qlf_avi, q.qlf_valide
FROM            T_pilote_pil p 
LEFT OUTER JOIN T_qualifs_qlf q 
ON              p.pil_brevet = q.pil_brevet;

SELECT p.pil_brevet, q.qlf_avi, q.qlf_valide
FROM            T_qualifs_qlf q
RIGHT OUTER JOIN T_pilote_pil p 
ON              p.pil_brevet = q.pil_brevet;


INSERT INTO T_pilote_pil VALUES ('PL-5', 'Pascal','Larrazet', 1500,NULL);

DELETE FROM T_qualifs_qlf 
WHERE pil_brevet = 'PL-4' 
AND   qlf_avi = 'A340';

ALTER TABLE T_qualifs_qlf  DROP CONSTRAINT fk_qlf_pil;

INSERT INTO T_qualifs_qlf  VALUES ('PL-7', 'A380','20170708');

/* R9 */

SELECT  c.cmp_nom, p.pil_brevet, p.pil_prenom, p.pil_nom 
FROM            T_compagnie_cmp c
FULL OUTER JOIN T_pilote_pil p 
ON              p.cmp_comp  = c.cmp_comp;

SELECT  c.cmp_nom, p.pil_brevet, p.pil_prenom, p.pil_nom 
FROM            T_pilote_pil p 
FULL OUTER JOIN T_compagnie_cmp c
ON              p.cmp_comp  = c.cmp_comp;

/* R10 */

SELECT p.pil_brevet, q.qlf_avi, q.qlf_valide
FROM            T_qualifs_qlf q
FULL OUTER JOIN T_pilote_pil p 
ON              p.pil_brevet = q.pil_brevet;

SELECT p.pil_brevet, q.qlf_avi, q.qlf_valide
FROM            T_pilote_pil p 
FULL OUTER JOIN T_qualifs_qlf q 
ON              p.pil_brevet = q.pil_brevet;


IF OBJECT_ID('dbo.T_qualifs_qlf','U') IS NOT NULL
   DROP TABLE dbo.T_qualifs_qlf;
GO
IF OBJECT_ID('dbo.T_pilote_pil','U') IS NOT NULL
   DROP TABLE dbo.T_pilote_pil;
GO
IF OBJECT_ID('dbo.T_compagnie_cmp','U') IS NOT NULL
   DROP TABLE dbo.T_compagnie_cmp;
GO


